unit UnitOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Registry, IniFiles;

type
  TForm2 = class(TForm)
    BitBtn1: TBitBtn;
    OpenDialog: TOpenDialog;
    GroupBox1: TGroupBox;
    EditWavFile: TEdit;
    BitBtnWavFile: TBitBtn;
    CheckBoxPlayWav: TCheckBox;
    CheckBoxBeep: TCheckBox;
    CheckBoxAutoShow: TCheckBox;
    GroupBox2: TGroupBox;
    CheckBoxMinimized: TCheckBox;
    CheckBoxAutostart: TCheckBox;
    GroupBox3: TGroupBox;
    CheckBoxAcceptMessages: TCheckBox;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxAcceptMessagesClick(Sender: TObject);
    procedure CheckBoxPlayWavClick(Sender: TObject);
    procedure BitBtnWavFileClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

uses UnitMain;

procedure TForm2.FormDestroy(Sender: TObject);
var Ini: TIniFile;
    Reg: TRegistry;
begin
   try
     Ini := TIniFile.Create(ExtractFilePath(Application.ExeName)+'\Settings.ini');
     Ini.WriteBool  ('Incomming', 'PlayWave', CheckBoxPlayWav.Checked);
     Ini.WriteString('incomming', 'WaveFile', EditWavFile.Text);
     Ini.WriteBool  ('Incomming', 'Beep', CheckBoxBeep.Checked);
     Ini.WriteBool  ('Incomming', 'AutoMaximize', CheckBoxAutoShow.Checked);
     Ini.WriteBool  ('Startup', 'StartMinimized', CheckBoxMinimized.Checked);
     Ini.WriteBool  ('Misc', 'AcceptMessages', CheckBoxAcceptMessages.Checked); 
   finally;
     Ini.Free;
   end;

   try
     Reg := TRegistry.Create;
     Reg.RootKey := HKEY_CURRENT_USER;
     Reg.OpenKey ('Software\Microsoft\Windows\CurrentVersion\Run', true);
     if CheckBoxAutostart.Checked then
        Reg.WriteString ('WGMess', Application.ExeName)
     else
        Reg.DeleteValue('WGMess'); 
   finally
     Reg.Free;
   end;

end;

procedure TForm2.FormCreate(Sender: TObject);
var Ini: TIniFile;
    Reg: TRegistry;
begin
   try
     Ini := TIniFile.Create(ExtractFilePath(Application.ExeName)+'\Settings.ini');
     CheckBoxPlayWav.Checked   := Ini.ReadBool   ('Incomming', 'PlayWave', false);
     EditWavFile.Text          := Ini.ReadString ('Incomming', 'WaveFile', '');
     CheckBoxBeep.Checked      := Ini.ReadBool   ('Incomming', 'Beep', true);
     CheckBoxAutoShow.Checked  := Ini.ReadBool   ('Incomming', 'AutoMaximize', true);
     CheckBoxMinimized.Checked := Ini.ReadBool   ('Startup', 'StartMinimized', true);
     CheckBoxAcceptMessages.Checked := Ini.ReadBool  ('Misc', 'AcceptMessages', true);
   finally;
     Ini.Free;
   end;

   try
     Reg := TRegistry.Create;
     Reg.RootKey := HKEY_CURRENT_USER;
     Reg.OpenKeyReadOnly('Software\Microsoft\Windows\CurrentVersion\Run');
     CheckBoxAutostart.Checked := Reg.ValueExists ('WGMess');
   finally
     Reg.Free;
   end;

   Form1.NachrichtenEmpfangen.Checked := CheckBoxAcceptMessages.Checked;
   EditWavFile.Enabled := CheckBoxPlayWav.Checked;
end;

procedure TForm2.CheckBoxAcceptMessagesClick(Sender: TObject);
begin
  Form1.NachrichtenEmpfangen.Checked := CheckBoxAcceptMessages.Checked;
  if Form1.NachrichtenEmpfangen.Checked then
    Form1.ShowIcon (Application.Icon, 0, 'Nachrichtenempfang aktiv')
  else
    Form1.ShowIcon (Application.Icon, 0, 'Nachrichtenempfang deaktiviert');
end;

procedure TForm2.CheckBoxPlayWavClick(Sender: TObject);
begin
   EditWavFile.Enabled := CheckBoxPlayWav.Checked;
   if (Length(EditWavFile.Text) = 0) and CheckBoxPlayWav.Checked then
     BItBtnWavFileClick (nil); 
end;

procedure TForm2.BitBtnWavFileClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.exe';
  OpenDialog.Filename := EditWavFile.Text;
  OpenDialog.Filter := 'Autiodateien (*.WAV)|*.wav';
  OpenDialog.Options := [ofPathMustExist, ofFileMustExist];
  if OpenDialog.Execute then
    EditWavFile.Text := OpenDialog.Filename
  else
    CheckBoxPlayWav.Checked := false;
end;

end.
