unit GraphicUtils;

interface

procedure ScalePic(const SourceWidth, SourceHeight, DestWidth,
  DestHeight: Integer; var NewWidth, NewHeight: Integer);

implementation

procedure ScalePic(const SourceWidth, SourceHeight, DestWidth,
  DestHeight: Integer; var NewWidth, NewHeight: Integer);
var Ratio: Single;
Begin
  try
    if (SourceWidth - DestWidth) > (SourceHeight - DestHeight) then begin
      NewWidth := DestWidth;
      Ratio := SourceHeight / SourceWidth;
      NewHeight := Round(NewWidth * Ratio);
      If NewHeight > DestHeight then begin
        NewHeight := DestHeight;
        NewWidth := Round(NewHeight / Ratio);
      end;
    end else begin
        NewHeight := DestHeight;
        Ratio := SourceWidth / SourceHeight;
        NewWidth := Round(NewHeight * Ratio);
        if NewWidth > DestWidth then begin
          NewWidth := DestWidth;
          NewHeight := Round(NewWidth / Ratio);
        end;
    end ;
  except
     NewWidth  := 0;
     NewHeight := 0;
  end;
end;
end.
 