unit UnitList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, Menus, DXSprite,
  { Selfmade }
  Sprites;

type
  TFormList = class(TForm)
    ListView1: TListView;
    PopupMenu1: TPopupMenu;
    Delete1: TMenuItem;
    Center1: TMenuItem;
    procedure Select1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure Center1Click(Sender: TObject);
    procedure ListView1Editing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  FormList: TFormList;

implementation

uses UnitMain;

{$R *.dfm}

procedure TFormList.Select1Click(Sender: TObject);
var Sprite: TSprite;
begin

  Sprite := TSprite(ListView1.Items[ListView1.ItemIndex].Data);

  if Sprite is TMapSprite then begin
    FormMain.Properties1.Execute;
    Exit;
  end;

  with FormMain do begin
    MCursor.Image := TObjectSprite(Sprite).Image;
    with ImagePreview.Canvas do begin
      Brush.Color := clWhite;
      FillRect(ClientRect);
      Draw(0, 0, MCursor.Image.Picture.Graphic);
    end;
    MCursor.Width := TObjectSprite(Sprite).Width;
    MCursor.Height := TObjectSprite(Sprite).Height;
    MCursor.Z := TObjectSprite(Sprite).Z;
    ListBoxLib.ItemIndex := TObjectSprite(Sprite).ImageIndex;
    SpinEditZ.Value := TObjectSprite(Sprite).Z;
    SpinEditType.Value := TObjectSprite(Sprite).Id;
    EditName.Text := TObjectSprite(Sprite).Name;
    Sprite.Dead;
  end;
end;

procedure TFormList.Delete1Click(Sender: TObject);
var Sprite: TObjectSprite;
begin
  Sprite := TObjectSprite(ListView1.Items[ListView1.ItemIndex].Data);
  Sprite.Dead;
  FormMain.DXSpriteEngine1.Dead;
  FormActivate(nil);
end;

procedure TFormList.ListView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var Point: TPoint;
    Item: TListItem;
begin
  Item := ListView1.GetItemAt(x, y);
  if not Assigned(Item) then exit;

  if Button = mbLeft then begin


  end;

  if Button = mbRight then begin
    GetCursorPos(Point);
    ListView1.ScreenToClient(Point);
    if ListView1.ItemIndex > 0 then begin
      Delete1.Enabled := true;
      PopupMenu1.Popup(Point.X, Point.Y)
    end else begin
      Delete1.Enabled := false;
      PopupMenu1.Popup(Point.X, Point.Y);
    end;
  end;
end;

procedure TFormList.FormActivate(Sender: TObject);
var i: Integer;
    Sprite: TSprite;
    Item: TListItem;
begin
  FormList.ListView1.Clear;
  with FormMain do begin
    for i := 0 to DXSpriteEngine1.Engine.AllCount - 1 do begin
      Sprite := DXSpriteEngine1.Engine.Items[i];
      if Sprite is TObjectSprite then begin
        Item := ListView1.Items.Add;
        Item.Caption := IntToStr(i);
        Item.SubItems.Add(TObjectSprite(Sprite).Name);
        Item.SubItems.Add(FloatToStr(TObjectSprite(Sprite).X));
        Item.SubItems.Add(FloatToStr(TObjectSprite(Sprite).Y));
        Item.SubItems.Add(IntToStr(TObjectSprite(Sprite).Z));
        Item.SubItems.Add(IntToStr(TObjectSprite(Sprite).Image.Width));
        Item.SubItems.Add(IntToStr(TObjectSprite(Sprite).Image.Height));
        Item.SubItems.Add(IntToStr(TObjectSprite(Sprite).ImageIndex));
        Item.SubItems.Add(TObjectSprite(Sprite).ImageName);
        Item.SubItems.Add(InttoStr(TObjectSprite(Sprite).ID)); 
        Item.Data := Sprite;
      end;
      if Sprite is TMapSprite then begin
        Item := ListView1.Items.Add;
        Item.Caption := IntToStr(i);
        Item.SubItems.Add(TMapSprite(Sprite).Name);
        Item.SubItems.Add(FloatToStr(TMapSprite(Sprite).X));
        Item.SubItems.Add(FloatToStr(TMapSprite(Sprite).Y));
        Item.SubItems.Add(IntToStr(TMapSprite(Sprite).Z));
        if Assigned(TMapSprite(Sprite).Image) then begin
          Item.SubItems.Add(IntToStr(TMapSprite(Sprite).Image.Width));
          Item.SubItems.Add(IntToStr(TMapSprite(Sprite).Image.Height));
          Item.SubItems.Add(IntToStr(TMapSprite(Sprite).ImageIndex));
          Item.SubItems.Add(TMapSprite(Sprite).ImageName);
        end else begin
          Item.SubItems.Add('n/a');
          Item.SubItems.Add('n/a');
          Item.SubItems.Add('n/a');
          Item.SubItems.Add('n/a');
        end;
        Item.Data := Sprite;
      end;
    end;
  end;
end;

procedure TFormList.FormDeactivate(Sender: TObject);
begin
  FormMain.ToolButton12.Down := false;
  Hide;
end;

procedure TFormList.FormCreate(Sender: TObject);
begin
  FormList.Top := FormMain.ClientHeight - FormList.Height;
  FormList.Width := FormMain.ClientWidth - FormMain.Panel1.Width;
  FormList.Left := (FormMain.ClientWidth - FormList.Width) DIV 2;
end;

procedure TFormList.ListView1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  FormMain.StatusBar1.Panels[3].Text := '# of objects: ' + IntToStr(FormMain.DXSpriteEngine1.Engine.AllCount - 2)
end;

procedure TFormList.Center1Click(Sender: TObject);
var Sprite: TSprite;
begin
  Sprite := TSprite(ListView1.Items[ListView1.ItemIndex].Data);
  FormMain.DXSpriteEngine1.Engine.x := Sprite.x;
  FormMain.DXSpriteEngine1.Engine.x := FormMain.DXSpriteEngine1.Engine.x / 2;
  FormMain.DXSpriteEngine1.Engine.y := Sprite.y;
  FormMain.DXSpriteEngine1.Engine.x := FormMain.DXSpriteEngine1.Engine.x / 2;
end;

procedure TFormList.ListView1Editing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  if Item.Index = 0 then AllowEdit := false else AllowEdit := true; 
end;

end.
