unit Sprites;

interface

uses DXSprite, Classes, DXDraws;

type
  TMapSprite = class(TBackgroundSprite)
    private
      FName: ShortString;
      FImageName: ShortString;
      FImageIndex: Integer;
      FGetImageByName: Boolean;
    public
      property GetImageByName: Boolean read FGetImageByName write FGetImageByName default false;
      property Name: ShortString read FName write FName;
      property ImageName: ShortString read FImageName write FImageName;
      property ImageIndex: Integer read FImageIndex write FImageIndex;
      procedure StoreData (Stream: TStream);
      procedure LoadData (iml: TDXImageList; Stream: TStream);
  end;

  TObjectSprite = class(TImageSprite)
    private
      FID: Integer;
      FName: ShortString;
      FImageName: ShortString;
      FImageIndex: Integer;
      FGetImageByName: Boolean;
    public
      property GetImageByName: Boolean read FGetImageByName write FGetImageByName default false;
      property ID: Integer read FID write FID;
      property Name: ShortString read FName write FName;
      property ImageName: ShortString read FImageName write FImageName;
      property ImageIndex: Integer read FImageIndex write FImageIndex;
      procedure StoreData (Stream: TStream);
      procedure LoadData (iml: TDXImageList; Stream: TStream);
  end;

implementation

uses Graphics;

{ TObjectSprite }

procedure TObjectSprite.LoadData(iml: TDXImageList; Stream: TStream);
var col: TColor;
    int: Integer;
    doub: Double;
    bol: Boolean;
begin
  Stream.Read(FName[0], 1);
  Stream.Read(FName[1], Byte(FName[0]));
  Stream.Read(FImageName[0], 1);
  Stream.Read(FImageName[1], Byte(FImageName[0]));
  Stream.Read(FID, SizeOf(FID));
  Stream.Read(FImageIndex, SizeOf(FImageIndex));
  if FGetImageByName then
    Image := Iml.Items.Find(FImageName)
  else
    Image := Iml.Items[FImageIndex];
  Width := Image.Width;
  Height := Image.Height;
  Stream.Read(bol, SizeOf(bol));
  // Image.Transparent := Trans;  { Both not needed because it is saved in the image list }
  Stream.Read(col, SizeOf(col));
  // Image.TransparentColor := TransCol;
  Stream.Read(bol, SizeOf(bol));
  AnimLooped := bol;
  Stream.Read(int, SizeOf(int));
  AnimCount := int;
  Stream.Read(doub, SizeOf(doub));
  AnimSpeed := doub;
  Stream.Read(int, SizeOf(int));
  AnimStart := int;
  Stream.Read(doub, SizeOf(doub));
  x := doub;
  Stream.Read(doub, SizeOf(doub));
  y := doub;
  Stream.Read(int, SizeOf(int));
  z := int;
end;

procedure TObjectSprite.StoreData(Stream: TStream);
begin
  Stream.Write(FName, Length(FName) + 1);
  Stream.Write(FImageName, Length(FImageName) + 1);
  Stream.Write(FID, SizeOf(FID));
  Stream.Write(FImageIndex, SizeOf(FImageIndex));
  Stream.Write(Image.Transparent, SizeOf(Image.Transparent));
  Stream.Write(Image.TransparentColor, SizeOf(Image.TransparentColor));
  Stream.Write(AnimLooped, SizeOf(AnimLooped));
  Stream.Write(AnimCount, SizeOf(AnimCount));
  Stream.Write(AnimSpeed, SizeOf(AnimSpeed));
  Stream.Write(AnimStart, SizeOf(AnimStart)); 
  Stream.Write(x, SizeOf(x));
  Stream.Write(y, SizeOf(y));
  Stream.Write(z, SizeOf(z));
end;

{ TMapSprite }

procedure TMapSprite.LoadData(Iml: TDXImageList; Stream: TStream);
var bol: Boolean;
    col: TColor;
    ix, iy, ic, int: Integer;
    doub: Double;
begin
  Stream.Read(FName[0], 1);
  Stream.Read(FName[1], Byte(FName[0]));
  Stream.Read(FImageName[0], 1);
  Stream.Read(FImageName[1], Byte(FImageName[0]));
  Stream.Read(FImageIndex, SizeOf(FImageIndex));
  if FGetImageByName then
    Image := Iml.Items.Find(FImageName)
  else
    Image := Iml.Items[FImageIndex];
  Width := Image.Width;
  Height := Image.Height;
  Stream.Read(bol, SizeOf(bol));
  // Image.Transparent := Trans;  { Both not needed because it is saved in the image list }
  Stream.Read(col, SizeOf(col));
  // Image.TransparentColor := TransCol;
  Stream.Read(bol, SizeOf(bol));
  Tile := bol;
  Stream.Read(int, SizeOf(int));
  MapWidth := int;
  Stream.Read(int, SizeOf(int));
  MapHeight := int;
  Stream.Read(doub, SizeOf(doub));
  x := doub;
  Stream.Read(doub, SizeOf(doub));
  y := doub;
  Stream.Read(int, SizeOf(int));
  z := int;
  for ix := 0 to MapWidth - 1 do
    for iy := 0 to MapHeight - 1 do begin
      Stream.Read(ic, SizeOf(ic));
      Chips[ix, iy] := ic;
    end;
end;

procedure TMapSprite.StoreData(Stream: TStream);
var ix, iy, ic: Integer;
begin
  Stream.Write(FName, Length(FName) + 1);
  Stream.Write(FImageName, Length(FImageName) + 1);
  Stream.Write(FImageIndex, SizeOf(FImageIndex));
  Stream.Write(Image.Transparent, SizeOf(Image.Transparent));
  Stream.Write(Image.TransparentColor, SizeOf(Image.TransparentColor));
  Stream.Write(Tile, SizeOf(Tile));
  Stream.Write(MapWidth, SizeOf(MapWidth));
  Stream.Write(MapHeight, SizeOf(MapHeight));
  Stream.Write(x, SizeOf(x));
  Stream.Write(y, SizeOf(y));
  Stream.Write(z, SizeOf(z));
  for ix := 0 to MapWidth - 1 do
    for iy := 0 to MapHeight - 1 do begin
      ic := Chips[ix, iy];
      Stream.Write(ic, SizeOf(ic));
    end;
end;

end.

